<!DOCTYPE html>
<html lang="en">

<head>

    <!-- Meta Tag -->
    <meta charset="utf-8">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <link href="<?php echo e(asset('assets/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/toastr.min.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('assets/css/style.css')); ?>" rel="stylesheet">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.css">

    <style>
        .list-group-item {
            padding-top: 18px !important;
            padding-bottom: 18px !important;
            background-color: transparent;
        }
        .dropdown-menu, .card {
            background-color: #ffffffe3;
            border: none;
        }
        .form-control {
            background-color: #ffffff;
            color: var(--title-color);
        }
        .main-content {
            display: flex;
            justify-content: center;
            width: 100%;
            height: 100vh;
            padding-top: 70px;
            background-image: url("../public/assets/imgs/install_bg.png");
            background-size: cover;
        }
    </style>
</head>

<body>

    <?php echo $__env->yieldContent('content'); ?>

    <div style="display:none" id="dvloader"><img src="<?php echo e(asset('assets/imgs/loading.gif')); ?>" /></div>

    <!-- Feather Icon -->
    <script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>
    <!-- Jquery -->
    <script src="<?php echo e(asset('assets/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/bootstrap/js/bootstrap.min.js')); ?>"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Toastr -->
    <script src="<?php echo e(asset('assets/js/toastr.min.js')); ?>"></script>

    <script>
        // Toastr MSG Show
        <?php if(Session::has('error')): ?>
        toastr.error('<?php echo e(Session::get("error")); ?>');
        <?php elseif(Session::has('success')): ?>
        toastr.success('<?php echo e(Session::get("success")); ?>');
        <?php endif; ?>

        function showLoder() {
            $("#dvloader").show();
        }
    </script>
</body>

</html><?php /**PATH /opt/lampp/htdocs/envato/app/dtpocket_fm/resources/views/installation/layout/page-app.blade.php ENDPATH**/ ?>