
<?php $__env->startSection('page_title',  __('Label.SMTP_Setting')); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="right-content">
        <?php echo $__env->make('admin.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm"><?php echo e(__('Label.SMTP_Setting')); ?></h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><a href="<?php echo e(route('setting')); ?>">App Settings</a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Label.SMTP Setting')); ?></li>
                    </ol>
                </div>
            </div>

            <div class="card custom-border-card mt-3">
                <h5 class="card-header"><?php echo e(__('Label.Email Setting [SMTP]')); ?></h5>
                <div class="card-body">
                    <form id="smtp_setting">
                        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                        <input type="hidden" name="id" value="<?php if($smtp): ?><?php echo e($smtp->id); ?><?php endif; ?>">
                        <div class="form-row">
                            <div class="form-group  col-md-3">
                                <label><?php echo e(__('Label.IS SMTP Active')); ?></label>
                                <select name="status" class="form-control">
                                    <option value="">Select Status</option>
                                    <option value="0" <?php if($smtp): ?><?php echo e($smtp->status == 0  ? 'selected' : ''); ?><?php endif; ?>><?php echo e(__('Label.No')); ?></option>
                                    <option value="1" <?php if($smtp): ?><?php echo e($smtp->status == 1  ? 'selected' : ''); ?><?php endif; ?>><?php echo e(__('Label.Yes')); ?></option>
                                </select>
                            </div>
                            <div class="form-group col-md-3">
                                <label><?php echo e(__('Label.Host')); ?></label>
                                <input type="text" name="host" class="form-control" value="<?php if($smtp): ?><?php echo e($smtp->host); ?><?php endif; ?>" placeholder="Enter Host">
                            </div>
                            <div class="form-group col-md-3">
                                <label><?php echo e(__('Label.Port')); ?></label>
                                <input type="text" name="port" class="form-control" value="<?php if($smtp): ?><?php echo e($smtp->port); ?><?php endif; ?>" placeholder="Enter Port">
                            </div>
                            <div class="form-group col-md-3">
                                <label><?php echo e(__('Label.Protocol')); ?></label>
                                <input type="text" name="protocol" class="form-control" value="<?php if($smtp): ?><?php echo e($smtp->protocol); ?><?php endif; ?>" placeholder="Enter Protocol">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-3">
                                <label><?php echo e(__('Label.User name')); ?></label>
                                <input type="text" name="user" class="form-control" value="<?php if($smtp): ?><?php echo e($smtp->user); ?><?php endif; ?>" placeholder="Enter User Name">
                            </div>
                            <div class="form-group col-md-3">
                                <label><?php echo e(__('Label.Password')); ?></label>
                                <input type="password" name="pass" class="form-control" value="<?php if($smtp): ?><?php echo e($smtp->pass); ?><?php endif; ?>" placeholder="Enter Password">
                                <label class="mt-1 text-gray">Search for better result <a href="https://support.google.com/mail/answer/185833?hl=en" target="_blank" class="btn-link">Click Here</a></label>
                            </div>
                            <div class="form-group col-md-3">
                                <label><?php echo e(__('Label.From name')); ?></label>
                                <input type="text" name="from_name" class="form-control" value="<?php if($smtp): ?><?php echo e($smtp->from_name); ?><?php endif; ?>" placeholder="Enter From Name">
                            </div>
                            <div class="form-group col-md-3">
                                <label><?php echo e(__('Label.From Email')); ?></label>
                                <input type="text" name="from_email" class="form-control" value="<?php if($smtp): ?><?php echo e($smtp->from_email); ?><?php endif; ?>" placeholder="Enter From Email">
                            </div>
                        </div>
                        <div class="border-top pt-3 text-right">
                            <button type="button" class="btn btn-default mw-120" onclick="smtp_setting()"><?php echo e(__('Label.SAVE')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
    <script>
        function smtp_setting() {
            var formData = new FormData($("#smtp_setting")[0]);
            $.ajax({
                type: 'POST',
                url: '<?php echo e(route("smtp.save")); ?>',
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                success: function(resp) {
                    get_responce_message(resp, 'smtp_setting', '<?php echo e(route("setting")); ?>');
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    toastr.error(errorThrown.msg, 'failed');
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtpocket_fm/resources/views/admin/setting/smtp.blade.php ENDPATH**/ ?>